<?php

require 'get-ip.php';

function logRequest($data) {
    $logFile = "log-ip.txt";
    $currentDate = date("Y-m-d H:i:s");
    $logMessage = $currentDate . " - ==== IP CHANGER ==== Request: " . json_encode($data) . "\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

$endpoint = 'https://affiliates.spacecrm.org/api/signup/procform';

$data = file_get_contents('php://input');

if ($data) {
    $json = json_decode($data, true);
    if ($json) {
        $json['userip'] = getIp($json['phone']);
        $data = json_encode($json);
    }
}

logRequest($json);

$headers = [
    'x-trackbox-username: ' . $_SERVER['HTTP_X_TRACKBOX_USERNAME'],
    'x-trackbox-password: ' . $_SERVER['HTTP_X_TRACKBOX_PASSWORD'],
    'x-api-key: ' . $_SERVER['HTTP_X_API_KEY'],
    'Content-Type: application/json'
];

$ch = curl_init($endpoint);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

logRequest($response);
http_response_code($httpcode);
echo $response;
?>
